<?php
// -*- coding: utf-8 -*-
//
//  Copyright (c) nkd. 2010
//
//  $Id: loader.php,v 1.1 2010/12/07 14:50:04 nkd Exp $
//
//ソフト関係の設定
define('MAIN_SITE_NAME','NEO');
define('MAIN_SITE_URL','https://www.mail-neo.com');
define('SOFT_NAME','NEO');
define('SOFT_DIR_NAME','neo');
define('INSTALLER_PHP','neo_install_system.php');
define('INDEX_HTML','neo.html');

//ソフトに共通の設定
define('DL_URL',MAIN_SITE_URL.'/downloads/targz/%s/%s/%s');
define('TAR_FILE','neo.tar.gz');
define('TAR_FILE2','neo.tar');
define('SOURCE_DIR','neo');
define('LOADER_DL_URL',MAIN_SITE_URL.'/downloads/ioncube/%s');
define('LOADER_TAR_FILE','ioncube.tar.gz');
define('LOADER_TAR_FILE2','ioncube.tar');
define('LOADER_SOURCE_DIR','ioncube');
define('SQLDIR','backend/database');
define('DBCONFFILE','backend/lib/config/database.php');
define('VERFILE','backend/lib/config/verup.php');
define('REG_URL',MAIN_SITE_URL.'/servers/reg/%s');

//ローダ関係の設定
define ('ERROR_UNKNOWN_OS',1);
define ('ERROR_UNSUPPORTED_OS',2);
define ('ERROR_UNKNOWN_ARCH',3);
define ('ERROR_UNSUPPORTED_ARCH',4);
define ('ERROR_UNSUPPORTED_ARCH_OS',5);
define ('ERROR_WINDOWS_64_BIT',6);
define ('LOADERS_PACKAGE_PREFIX','ioncube_loaders_');
define ('IONCUBE_DOWNLOADS_SERVER','https://downloads.ioncube.com/loader_downloads');
define ('LOADER_PLATFORM_URL','https://www.ioncube.com/feeds/product_info/versions.php?item=loader-platforms');
define ('PHP_COMPILERS_URL','https://www.ioncube.com/feeds/product_info/versions.php?item=php-compilers');
define ('LOADER_EXTENSION_NAME','ionCube Loader');

//その他の設定
ini_set('default_charset', 'UTF-8');
ini_set('mbstring.language','Japanese');
ini_set('mbstring.internal_encoding','UTF-8');
ini_set('mbstring.http_output','UTF-8');
ini_set('mbstring.substitute_character','none');
ini_set('mbstring.detect_order','auto');
ini_set('magic_quotes_gpc','0');
ini_set('mbstring.encoding_translation','1');
ini_set('mbstring.http_input','auto');

//error_reporting(E_ERROR | E_WARNING | E_PARSE);
error_reporting(0);

//処理開始
$querystring=env('QUERY_STRING');
if(!empty($querystring)) {
	$querystring = urldecode( $querystring );
	$pairs       = explode( '\&', $querystring );
	$qparams     = array();
	foreach ( $pairs as $pair ) {
		$tmp                = explode( '=', $pair );
		$qparams[ $tmp[0] ] = $tmp[1];
	}

	if ( $qparams['act'] == 'cli' ) {
		$loader = new loader();
		$re     = array();
		if ( ! $loader->is_supported_php_version() ) {
			$re['err'][] = 'php_version';
		}
		if ( $loader->is_safe_mode() ) {
			$re['err'][] = 'safe_mode';
		}
		if ( ! function_exists( 'mb_detect_encoding' ) ) {
			$re['err'][] = 'mb_detect_encoding';
		}
		if ( ! function_exists( 'mysql_connect' ) ) {
			$re['err'][] = 'mysql_connect';
		}
		if ( $loader->is_disable_functions() ) {
			$re['err'][] = 'disable_functions';
		}
		if ( $loader->is_open_basedir() ) {
			$re['err'][] = 'open_basedir';
		}
		if ( $loader->not_dl() ) {
			$re['err'][] = 'dl';
		}
		if ( $loader->phpver_and_extension_dir() ) {
			$re['err'][] = 'extension_dir';
		}
		if ( $loader->debug_build() ) {
			$re['err'][] = 'debug_build';
		}
		$re['ver'] = $loader->php_version();
		echo 'RESULT: ' . serialize( $re ) . "\n";
		exit;
	}
}

session_set_cookie_params(0, '/');
session_start();

if(!isset($_SESSION['sess_id']) || empty($_SESSION['sess_id'])){
	$_SESSION['sess_id']=make_session_id();
}else if($_SESSION['sess_id']!=make_session_id()){
	$_SESSION = array();
	if (ini_get("session.use_cookies")) {
		$params = session_get_cookie_params();
		setcookie(session_name(), '', time() - 42000,$params["path"], $params["domain"],$params["secure"], $params["httponly"]);
	}
	session_destroy();
	showError(array('セッション中に問題が発生しました。<a href='.INDEX_HTML.'>'.INDEX_HTML.'</a>から再度やりなおしてください。'));
	exit;
}

$params=array();
$params['form'] = stripslashes_deep($_POST);
$params['url'] = stripslashes_deep($_GET);

$act=(isset($params['form']['act']) && !empty($params['form']['act']))?$params['form']['act']:((isset($params['url']['act']) && !empty($params['url']['act']))?$params['url']['act']:'');

switch($act){
	case 'dl':
		$mailsoft=new mailsoft();
		if(!$mailsoft->fileSetting($params)){
			$mailsoft->showInputIdPw($mailsoft->get_error());
			break;
		}
		$mailsoft->regist(18);
		$mailsoft->showInput();
		break;
	case 'setdb':
		$mailsoft=new mailsoft();
		if(!$mailsoft->setDb($params)){
			$mailsoft->showInput($mailsoft->get_error());
			break;
		}
		$mailsoft->regist(17,$_SESSION['servername'],$_SESSION['servertype']);
		if(!$_SESSION['loadertype']){
			if(!$mailsoft->installLoader()){
				showError($mailsoft->get_error());
				break;
			}
			$mailsoft->regist(16,$_SESSION['servername'],$_SESSION['servertype']);
			if(!$mailsoft->checkLoader()){
				$mailsoft->showLoderErr();
				$mailsoft->regist(15,$_SESSION['servername'],$_SESSION['servertype']);
				break;
			}
		}
		$mailsoft->showEnd();
		$mailsoft->regist(10,$_SESSION['servername'],$_SESSION['servertype']);
		break;
	case 'input':
		$mailsoft=new mailsoft();
		if(!$mailsoft->checkInputPhpPath($params)){
			$mailsoft->showInputPhpPath($mailsoft->get_error());
			break;
		}
		$mailsoft->showInputIdPw();
		$mailsoft->regist(19);
		break;
	case 'senyo':
		$loader = new loader();
		$loader->senyo_page();
		break;
	case 'senyo_test':
		$loader = new loader();
		$loader->loader_check_page();
		break;
	case 'info':
		echo phpinfo();
		break;
	default:
		$mailsoft=new mailsoft();
		$mailsoft->regist();
		if(!$mailsoft->setDir($params)){
			showError($mailsoft->get_error());
			break;
		}
		if(!$mailsoft->checkParm()){
			showError($mailsoft->get_error());
			break;
		}
		if(!$mailsoft->checkEnv()){
			showError($mailsoft->get_error());
			break;
		}
		$mailsoft->showInputPhpPath();
}
exit;




//関数とか
function showHeader(){
	echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";
	?>
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja-JP" lang="ja-JP">
    <head>
        <title>システムのインストール</title>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <script type="text/javascript">
            <!--
            function showHide(targetID) {
                let obj=document.getElementById(targetID);
                if( obj) {
                    if( obj.style.display === "none") {
                        obj.style.display = "block";
                    } else {
                        obj.style.display = "none";
                    }
                }
            }

            let stripe = function() {
                let tables = document.getElementsByTagName("table");
                for(let x=0;x!==tables.length;x++){
                    let table = tables[x];
                    if (! table) { return; }
                    let tbodies = table.getElementsByTagName("tbody");
                    for (let h = 0; h < tbodies.length; h++) {
                        let even = true;
                        let trs = tbodies[h].getElementsByTagName("tr");
                        for (let i = 0; i < trs.length; i++) {
                            trs[i].onmouseover=function(){
                                this.className += " ruled"; return false;
                            };
                            trs[i].onmouseout=function(){
                                this.className = this.className.replace("ruled", ""); return false;
                            };
                            if(even)
                                trs[i].className += " even";
                            even = !even;
                        }
                    }
                }
            };
            window.onload = stripe;
            //-->
        </script>
        <style type="text/css">
            body{
                font-family:"frutiger linotype","lucida grande",helvetica,arial,sans-serif;
                text-align:center;
                color:#333;
                font-size: 76%;
            }

            /* General Style Info */
            a{
                color:#003d4c;
                text-decoration:underline;
            }
            a:hover{
                color:#003d4c;
                text-decoration:none;
            }

            h2 {
                color:inherit;
                background-color:#DDEEFF;
                padding:.3em;
                border:0;
                margin:0 0 .5em 0;
            }
            h3 {
                border-bottom:  3px solid #DDEEFF;
                border-top:     1px solid #DDEEFF;
                border-left:   10px solid #DDEEFF;
                border-right:   5px solid #DDEEFF;

                color:inherit;
                background-color:#FFFFFF;
                padding:.3em;
                margin:0 0 .5em 0;
            }

            #container{
                text-align:left;
            }

            #content{
                clear:both;
                padding: 20px 40px 10px 40px;
                background-color: #fff;
                color: #333;
            }

            /* tables */
            table {
                width: 100%;
                border-top: 1px solid #ccc;
                border-left: 1px solid #ccc;
                border-bottom: 1px solid #ccc;
                color:#333;
                background-color: #fff;
                clear:both;
                padding: 0;
                margin: 0 0 2em 0;
                white-space: normal;
            }
            th {
                background-color: #e2e2e2;
                border-top: 1px solid #fff;
                border-left: 1px solid #fff;
                border-right: 1px solid #003d4c;
                border-bottom: 1px solid #003d4c;
                text-align: center;
                padding:1px 4px;
            }
            table tr td {
                border-right: 1px solid #ddd;
                padding:4px 4px;
                vertical-align:top;
                #text-align: center;
            }
            table tr.altRow td {
                background: #f4f4f4;
            }
            table tr { background-color: #FAFAFA; }

            .err{
                background-color: #ffeeee;
                border: 1px solid #555555;
                height: auto;
                margin: 5px;
                padding: 5px;
                text-align: left;
                width: auto;
            }
            .msg{
                background-color: #eeffee;
                border: 1px solid #555555;
                height: auto;
                margin: 5px;
                padding: 5px;
                text-align: left;
                width: auto;
            }
        </style>
    </head>
    <body>
    <div id="container">
        <div id="content">
			<?php
			}

			function showFooter(){
			?>
            <br>
            <br>

        </div>
    </div>
    </body>
    </html>

	<?php
}

function showError($str) {
	if(is_array($str)){
		$str=make_list($str,'ul');
	}
	showHeader();
	?>

    <h3>エラー</h3>

	<?php echo $str; ?>
    <br>
    <br>
	<?php
	showFooter();
}

function make_list($list_items,$list_type='ol'){
	$html = '';
	if (!empty($list_items)) {
		$html .= "<$list_type>";
		$html .= '<li>';
		$html .= join('</li><li>',$list_items);
		$html .= '</li>';
		$html .= "</$list_type>";
	}
	return $html;
}

function make_session_id(){
	return md5(MAIN_SITE_URL.__FILE__.php_uname().phpversion());
}

function sanitize($value) {
	return htmlspecialchars($value,ENT_QUOTES);
}

function _stripslashes_deep($value) {
	if (is_array($value)) {
		$return = array_map('_stripslashes_deep', $value);
	} else {
		$return = stripslashes($value);
	}
	return $return;
}

function stripslashes_deep($value) {
	if (ini_get('magic_quotes_gpc') == 1) {
		if(count($value)) {
			return _stripslashes_deep($value);
		}
	}
	return $value;
}

function use_curl($file_source) {
	$ch = curl_init();
	curl_setopt( $ch, CURLOPT_URL, $file_source );
	curl_setopt( $ch, CURLOPT_HEADER, 0 );
	curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
	curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 5 );
	$output     = curl_exec( $ch );
	$info       = curl_getinfo( $ch );
	$timing_out = ( $info['http_code'] >= 400 ) ? 1 : 0;
	curl_close( $ch );

	return ( ! $timing_out && is_string( $output ) ) ? $output : null;
}

function download ($file_source, $file_target){
	$allow_url_fopen=ini_get('allow_url_fopen');
	if(!empty($allow_url_fopen)) {
		// Preparations
		$file_source = str_replace(' ', '%20', html_entity_decode($file_source)); // fix url format
		if (file_exists($file_target)) { chmod($file_target, 0777); } // add write permission

		// Begin transfer
		if (($rh = fopen($file_source, 'rb')) === FALSE) { return false; } // fopen() handles
		if (($wh = fopen($file_target, 'wb')) === FALSE) { return false; } // error messages.
		while (!feof($rh)){
			// unable to write to file, possibly because the harddrive has filled up
			if (fwrite($wh, fread($rh, 1024)) === FALSE) { fclose($rh); fclose($wh); return false; }
		}

		// Finished without errors
		fclose($rh);
		fclose($wh);
		return true;
	} elseif (extension_loaded('curl')) {
		$output=use_curl($file_source);
		if (is_string($output)) {
			file_put_contents($file_target, $output);
		}
	}else{
		$r = new MyHTTPRequest($file_source);
		file_put_contents($file_target, $r->DownloadToString());
	}
	return true;
}

function remote_file_contents($url)
{
	$allow_url_fopen=ini_get('allow_url_fopen');
	$contents = false;
	if (!empty($allow_url_fopen)) {
		$rh = @fopen($url,'rb');
		if ($rh) {
			while (!feof($rh)){
				$result = fread($rh, 8192);
				if ($result !== false) {
					$contents .= $result;
				} else {
					break;
				}
			}
			fclose($rh);
		}
	} elseif (extension_loaded('curl')) {
		$output=use_curl($url);
		if (is_string($output)) {
			$contents = $output;
		}
	}else{
		$r = new MyHTTPRequest($url);
		$contents = $r->DownloadToString();
	}
	return $contents;
}

if (!function_exists('file_put_contents')) {
	function file_put_contents($fileName, $data) {
		if (is_array($data)) {
			$data = join('', $data);
		}
		$res = @fopen($fileName, 'w+b');
		if ($res) {
			$write = @fwrite($res, $data);
			if($write === false) {
				return false;
			} else {
				return $write;
			}
		}
	}
}

function scanEntireDir($dir){
	$files=array();
	$dh  = opendir($dir);
	while (false !== ($filename = readdir($dh))) {
		$files[] = $filename;
	}
	closedir($dh);
	return $files;
}

function delTree($f){
	if (is_dir($f)) {
		foreach(scanEntireDir($f) as $item){
			if ( (!strcmp($item, '.')) OR (!strcmp($item, '..')) ) continue;
			delTree($f . "/" . $item); // recurision
		}
		@rmdir($f);
	}else{
		@unlink($f);
	}

	// check if deleted?
	if (is_dir($f)) return false;
	else return true;
}

function dircopy($srcdir, $dstdir, $verbose = false) {
	$num = 0;
	if(!is_dir($dstdir)) mkdir($dstdir);
	if($curdir = opendir($srcdir)) {
		while($file = readdir($curdir)) {
			if($file != '.' && $file != '..') {
				$srcfile = $srcdir . '/' . $file;
				$dstfile = $dstdir . '/' . $file;
				if(is_file($srcfile)) {
					if(is_file($dstfile)) $ow = filemtime($srcfile) - filemtime($dstfile); else $ow = 1;
					if($ow > 0) {
						if($verbose) echo "Copying '$srcfile' to '$dstfile'...";
						if(copy($srcfile, $dstfile)) {
							touch($dstfile, filemtime($srcfile)); $num++;
							if($verbose) echo "OK\n";
						}else{
							@unlink($dstfile);
							if(rename($srcfile, $dstfile)) {
								$num++;
								if($verbose) echo "OK\n";
							}else{
								echo "Error: File '$srcfile' could not be copied!\n";
							}
						}
					}
				}
				else if(is_dir($srcfile)) {
					$num += dircopy($srcfile, $dstfile, $verbose);
				}
			}
		}
		closedir($curdir);
	}
	return $num;
}

function exe($cmd){
	static $exeflag=null;

	if($exeflag===null){
		$re=shell_exec('ls -al');
		$re=trim($re);
		if(!empty($re)){
			$exeflag=1;
		}else{
			exec('ls -al',$re);
			if(is_array($re)){ $re=join("\n",$re); }
			$re=trim($re);
			if(!empty($re)){
				$exeflag=2;
			}else{
				$re=system('ls -al');
				$re=trim($re);
				if(!empty($re)){
					$exeflag=3;
				}else{
					$exeflag=99;
				}
			}
		}
	}

	if($exeflag==1){
		return trim(shell_exec($cmd));
	}elseif($exeflag==2){
		exec($cmd,$re);
		if(is_array($re)){ $re=join("\n",$re); }
		return trim($re);
	}elseif($exeflag==3){
		return trim(system($cmd));
	}
	return false;
}

function env($key) {
	if ($key == 'HTTPS') {
		if (isset($_SERVER) && !empty($_SERVER)) {
			return (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on');
		} else {
			return (strpos(env('SCRIPT_URI'), 'https://') === 0);
		}
	}

	if (isset($_SERVER[$key])) {
		return $_SERVER[$key];
	} elseif (isset($_ENV[$key])) {
		return $_ENV[$key];
	} elseif (getenv($key) !== false) {
		return getenv($key);
	}

	if ($key == 'DOCUMENT_ROOT') {
		$offset = 0;
		if (!strpos(env('SCRIPT_NAME'), '.php')) {
			$offset = 4;
		}
		return substr(env('SCRIPT_FILENAME'), 0, strlen(env('SCRIPT_FILENAME')) - (strlen(env('SCRIPT_NAME')) + $offset));
	}
	if ($key == 'PHP_SELF') {
		return str_replace(env('DOCUMENT_ROOT'), '', env('SCRIPT_FILENAME'));
	}
	return null;
}

function get_php_path() {
	$patharr=array();
	$re = trim(exe('whereis php'));
	if(!empty($re)){
		$paths=explode(' ',$re);
		if(!empty($paths)){
			foreach($paths as $path){
				$path=strtolower($path);
				if(substr($path,-4)==DIRECTORY_SEPARATOR.'php' && strpos($path,DIRECTORY_SEPARATOR.'bin'.DIRECTORY_SEPARATOR)!==false){
					$patharr[]=$path;
				}
			}
		}
	}
	if(empty($patharr)){
		return '/usr/bin/php';
	}else{
		if(in_array('/usr/bin/php',$patharr)){
			return '/usr/bin/php';
		}else{
			return $patharr[0];
		}
	}
}

class MyHTTPRequest
{
	var $_fp;        // HTTP socket
	var $_url;        // full URL
	var $_host;        // HTTP host
	var $_protocol;    // protocol (HTTP/HTTPS)
	var $_uri;        // request URI
	var $_port;        // port

	// scan url
	function _scan_url()
	{
		$req = $this->_url;

		$pos = strpos($req, '://');
		$this->_protocol = strtolower(substr($req, 0, $pos));

		$req = substr($req, $pos+3);
		$pos = strpos($req, '/');
		if($pos === false)
			$pos = strlen($req);
		$host = substr($req, 0, $pos);

		if(strpos($host, ':') !== false)
		{
			list($this->_host, $this->_port) = explode(':', $host);
		}
		else
		{
			$this->_host = $host;
			$this->_port = ($this->_protocol == 'https') ? 443 : 80;
		}

		$this->_uri = substr($req, $pos);
		if($this->_uri == '')
			$this->_uri = '/';
	}

	// constructor
	function __construct($url)
	{
		$this->_url = $url;
		$this->_scan_url();
	}

	// download URL to string
	function DownloadToString()
	{
		$crlf = "\r\n";
		$response = '';

		// generate request
		$req = 'GET ' . $this->_uri . ' HTTP/1.0' . $crlf
		       .    'Host: ' . $this->_host . $crlf
		       .    $crlf;

		// fetch
		$this->_fp = fsockopen(($this->_protocol == 'https' ? 'ssl://' : '') . $this->_host, $this->_port);
		fwrite($this->_fp, $req);
		while(is_resource($this->_fp) && $this->_fp && !feof($this->_fp))
			$response .= fread($this->_fp, 1024);
		fclose($this->_fp);

		// split header and body
		$pos = strpos($response, $crlf . $crlf);
		if($pos === false)
			return($response);
		$header = substr($response, 0, $pos);
		$body = substr($response, $pos + 2 * strlen($crlf));

		// parse headers
		$headers = array();
		$lines = explode($crlf, $header);
		foreach($lines as $line)
			if(($pos = strpos($line, ':')) !== false)
				$headers[strtolower(trim(substr($line, 0, $pos)))] = trim(substr($line, $pos+1));

		// redirection?
		if(isset($headers['location']))
		{
			$http = new MyHTTPRequest($headers['location']);
			return($http->DownloadToString());
		}
		else
		{
			return($body);
		}
	}
}

class database{
	var $conn=null;
	var $host=null;
	var $user=null;
	var $password=null;
	var $database=null;
	var $result=null;
	var $error=null;
//	var $_result=null;

	function connect($host,$user,$password){
		$this->host=$host;
		$this->user=$user;
		$this->password=$password;
		$this->conn=mysqli_connect($this->host,$this->user,$this->password);
		if(!$this->conn){
			return false;
		}
		return true;
	}

	function select_db($database){
		$this->database=$database;
		return mysqli_select_db($this->conn,$this->database);
	}

	function escape($str){
		return mysqli_real_escape_string($this->conn,$str);
	}

	function close(){
		if($this->conn) mysqli_close($this->conn);
	}

	function checkVersion(){
		if(defined('_MYSQL_INT_VERSION')){
			return true;
		}
		$query = "SELECT VERSION();";
		$re=mysqli_query($this->conn,$query);
		if(!$re){
			return false;
		}
		$mysql_version=$this->fetchResult($re, 0);
		$match = explode('.', $mysql_version);
		$mysql_int_version = (int) sprintf('%d%02d%02d', $match[0], $match[1], intval($match[2]));
		define('_MYSQL_INT_VERSION',$mysql_int_version);

		if($mysql_int_version>400){
			$query="SET NAMES utf8";
			$re=mysqli_query($this->conn,$query);
			if(!$re){
				return false;
			}
		}
		return true;
	}

	function lastError() {
		if (mysqli_errno($this->conn)) {
			return mysqli_errno($this->conn).': '.mysqli_error($this->conn);
		}
		return null;
	}

	function get_error(){
		return 	$this->error;
	}

	function execute($sql) {
		$this->result = mysqli_query($this->conn, $sql);
		$this->error = $this->lastError();

		if ($this->error) {
			return false;
		} else {
			return $this->result;
		}
	}

	function fetchResult($result=null,$row=0) {
		$result=($result!=null)?$result:$this->result;
		$field = 0;
		if ( ! mysqli_data_seek( $result, $row ) ) {
			return false;
		}
		if ( ! ( $_row = mysqli_fetch_array( $result ) ) ) {
			return false;
		}
		if ( ! array_key_exists( $field, $_row ) ) {
			return false;
		}

		return $_row[ $field ];
	}

	function findAll($query) {
		$re=$this->execute($query);
		if(!$re)
		{
			return null;
		}
		return $this->fetchAssoc($re);
	}

	function fetchAssoc($result=null) {
		$result    = ( $result != null ) ? $result : $this->_result;
		$resultRow = array();
		while ($row = mysqli_fetch_assoc($result)) {
			$resultRow[]=$row;
		}
		return !count($resultRow)?null:$resultRow;
	}

	function get_tables(){
		$query = sprintf("SHOW TABLES FROM `%s`;",$this->escape($this->database));
		$result=$this->execute($query);
		if (!$result) {
			return false;
		}
		$tables=array();
		while ($row = mysqli_fetch_row($result)) {
			$tables[] = '`'.$this->escape($row[0]).'`';
		}
		return $tables;
	}
}

class loader{
	function get_platforminfo()
	{
		static $platforminfo;

		$sessid=session_id();
		if(!empty($sessid)){
			if (isset($_SESSION['platforminfo']) && !empty($_SESSION['platforminfo'])) {
				return $_SESSION['platforminfo'];
			}
		}
		if (empty($platforminfo)) {
			$platforminfo = @unserialize(remote_file_contents(LOADER_PLATFORM_URL));
			if (empty($platforminfo)) {
				$platforminfo = $this->default_platform_list();
			}
		}
		if(!empty($sessid) && !empty($platforminfo)){
			$_SESSION['platforminfo']=$platforminfo;
		}
		return $platforminfo;
	}

	function default_platform_list(){
		$platforms = array();
		$platforms[] = array('os'=>'win', 'os_human'=>'Windows VC6',        'os_mod' => '_vc6',     'arch'=>'x86',  'dirname'=>'win32', 'us1-dir'=>'windows_vc6/x86' );
		$platforms[] = array('os'=>'win', 'os_human'=>'Windows VC6 (Non-TS)',   'os_mod' => '_nonts_vc6',   'arch'=>'x86',  'dirname'=>'win32-nonts', 'us1-dir'=>'windows_vc6/x86-nonts' );
		$platforms[] = array('os'=>'win', 'os_human'=>'Windows VC9',        'os_mod' => '_vc9',     'arch'=>'x86',  'dirname'=>'win32_vc9', 'us1-dir'=>'windows_vc9/x86' );
		$platforms[] = array('os'=>'win', 'os_human'=>'Windows VC9 (Non-TS)',   'os_mod' => '_nonts_vc9',   'arch'=>'x86',  'dirname'=>'win32-nonts_vc9', 'us1-dir'=>'windows_vc9/x86-nonts' );
		$platforms[] = array('os'=>'lin', 'os_human'=>'Linux',              'arch'=>'x86',      'dirname'=>'linux_i686-glibc2.1.3', 'us1-dir'=>'linux/x86');
		$platforms[] = array('os'=>'lin', 'os_human'=>'Linux',              'arch'=>'x86-64',   'dirname'=>'linux_x86_64-glibc2.3.4', 'us1-dir'=>'linux/x86_64');
		$platforms[] = array('os'=>'lin','os_human'=>'Linux',               'arch'=>'ppc',      'dirname'=>'linux_ppc-glibc2.3.4','us1-dir'=>'linux/ppc');
		$platforms[] = array('os'=>'lin','os_human'=>'Linux',               'arch'=>'ppc64',    'dirname'=>'linux_ppc64-glibc2.5','us1-dir'=>'linux/ppc64');
		$platforms[] = array('os'=>'dra', 'os_human'=>'DragonFly', 'arch'=>'x86',      'dirname'=>'dragonfly_i386-1.7', 'us1-dir'=>'Dragonfly/x86');
		$platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 4', 'os_mod'=>'_4',  'arch'=>'x86',      'dirname'=>'freebsd_i386-4.8', 'us1-dir'=>'FreeBSD/v4');
		$platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 6', 'os_mod'=>'_6',  'arch'=>'x86',      'dirname'=>'freebsd_i386-6.2', 'us1-dir'=>'FreeBSD/v6/x86');
		$platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 6', 'os_mod'=>'_6',  'arch'=>'x86-64',   'dirname'=>'freebsd_amd64-6.2', 'us1-dir'=>'FreeBSD/v6/AMD64');
		$platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 7', 'os_mod'=>'_7',  'arch'=>'x86',      'dirname'=>'freebsd_i386-7.3', 'us1-dir'=>'FreeBSD/v7/x86');
		$platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 7', 'os_mod'=>'_7',  'arch'=>'x86-64',   'dirname'=>'freebsd_amd64-7.3', 'us1-dir'=>'FreeBSD/v7/AMD64');
		$platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 8', 'os_mod'=>'_8',  'arch'=>'x86',      'dirname'=>'freebsd_i386-8.0', 'us1-dir'=>'FreeBSD/v8/x86');
		$platforms[] = array('os'=>'fre', 'os_human'=>'FreeBSD 8', 'os_mod'=>'_8',  'arch'=>'x86-64',   'dirname'=>'freebsd_amd64-8.0', 'us1-dir'=>'FreeBSD/v8/AMD64');
		$platforms[] = array('os'=>'bsd', 'os_human'=>'BSDi',               'arch'=>'x86',      'dirname'=>'bsdi_i386-4.3.1');
		$platforms[] = array('os'=>'net', 'os_human'=>'NetBSD',             'arch'=>'x86',      'dirname'=>'netbsd_i386-2.1','us1-dir'=>'NetBSD/x86');
		$platforms[] = array('os'=>'net', 'os_human'=>'NetBSD',             'arch'=>'x86-64',   'dirname'=>'netbsd_amd64-2.0','us1-dir'=>'NetBSD/x86_64');
		$platforms[] = array('os'=>'ope', 'os_human'=>'OpenBSD 4.2', 'os_mod'=>'_4.2',  'arch'=>'x86',  'dirname'=>'openbsd_i386-4.2', 'us1-dir'=>'OpenBSD/x86');
		$platforms[] = array('os'=>'ope', 'os_human'=>'OpenBSD 4.5', 'os_mod'=>'_4.5',  'arch'=>'x86',  'dirname'=>'openbsd_i386-4.5', 'us1-dir'=>'OpenBSD/x86');
		$platforms[] = array('os'=>'ope', 'os_human'=>'OpenBSD 4.6', 'os_mod'=>'_4.6',  'arch'=>'x86',  'dirname'=>'openbsd_i386-4.6', 'us1-dir'=>'OpenBSD/x86');
		$platforms[] = array('os'=>'ope', 'os_human'=>'OpenBSD 4.7', 'os_mod'=>'_4.7',  'arch'=>'x86-64', 'dirname'=>'openbsd_amd64-4.7', 'us1-dir' => 'OpenBSD/x86_64');
		$platforms[] = array('os'=>'dar', 'os_human'=>'OS X',               'arch'=>'ppc',      'dirname'=>'osx_powerpc-8.5','us1-dir'=>'OSX/ppc');
		$platforms[] = array('os'=>'dar', 'os_human'=>'OS X',               'arch'=>'x86',      'dirname'=>'osx_i386-8.11','us1-dir'=>'OSX/x86');
		$platforms[] = array('os'=>'dar', 'os_human'=>'OS X',               'arch'=>'x86-64',       'dirname'=>'osx_x86-64-10.2','us1-dir'=>'OSX/x86_64');
		$platforms[] = array('os'=>'sun', 'os_human'=>'Solaris',            'arch'=>'sparc',    'dirname'=>'solaris_sparc-5.9', 'us1-dir'=>'Solaris/sparc');
		$platforms[] = array('os'=>'sun', 'os_human'=>'Solaris',            'arch'=>'x86',      'dirname'=>'solaris_i386-5.10','us1-dir'=>'Solaris/x86');
		return $platforms;
	}

	function supported_os_variants($os_code,$arch_code)
	{
		if (empty($os_code)) {
			return ERROR_UNKNOWN_OS;
		}
		if (empty($arch_code)) {
			return ERROR_UNKNOWN_ARCH;
		}

		$os_found = false;
		$arch_found = false;
		$os_arch_matches = array();
		$pinfo = $this->get_platforminfo();

		foreach ($pinfo as $p) {
			if ($p['os'] == $os_code && $p['arch'] == $arch_code) {
				$os_arch_matches[$p['os_human']] = (isset($p['os_mod']))?(0 + str_replace('_','',$p['os_mod'])):'';
			}
			if ($p['os'] == $os_code) {
				$os_found = true;
			} elseif ($p['arch'] == $arch_code) {
				$arch_found = true;
			}
		}

		if (!empty($os_arch_matches)) {
			asort($os_arch_matches);
			return $os_arch_matches;
		} elseif (!$os_found) {
			return ERROR_UNSUPPORTED_OS;
		} elseif (!$arch_found) {
			return ERROR_UNSUPPORTED_ARCH;
		} else {
			return ERROR_UNSUPPORTED_ARCH_OS;
		}
	}

	function match_arch_pattern($str)
	{
		$arch = null;
		$arch_patterns = array(
			'i.?86'        => 'x86',
			'x86[-_]64'    => 'x86',
			'x86'          => 'x86',
			'amd64'        => 'x86',
			'ppc64'        => 'ppc',
			'ppc'          => 'ppc',
			'powerpc'      => 'ppc',
			'sparc'        => 'sparc',
			'sun'          => 'sparc'
		);

		foreach ($arch_patterns as $token => $a) {
			if (preg_match("/$token/i", $str)) {
				$arch = $a;
				break;
			}
		}
		return $arch;
	}

	function required_loader_arch($mach_info,$os_code,$wordsize)
	{
		if ($os_code == 'win') {
			$arch = ($wordsize == 32)?'x86':'x86-64';
			if ($wordsize != 32) {
				$arch = ERROR_WINDOWS_64_BIT;
			}
		} elseif (!empty($os_code)) {
			$arch = $this->match_arch_pattern($mach_info);
			if ($wordsize == 64) {
				if ($arch == 'x86') {
					$arch = 'x86-64';
				} elseif ($arch == 'ppc') {
					$arch = 'ppc64';
				}
			}
		} else {
			$arch = ERROR_UNKNOWN_ARCH;
		}
		return $arch;
	}

	function required_loader($unamestr = '')
	{
		$un = empty($unamestr)?php_uname():$unamestr;

		$php_major_version = substr(PHP_VERSION,0,3);

		$os_name = substr($un,0,strpos($un,' '));
		$os_code = empty($os_name)?'':strtolower(substr($os_name,0,3));

		$wordsize = ((-1^0xffffffff) ? 64 : 32);

		$arch = $this->required_loader_arch($un,$os_code,$wordsize);
		if (!is_string($arch)) {
			return $arch;
		}
		$os_variants = $this->supported_os_variants($os_code,$arch);
		if (!is_array($os_variants)) {
			return $os_variants;
		}

		$os_ver = '';
		if (preg_match('/([0-9.]+)/',php_uname('r'),$match)) {
			$os_ver = $match[1];
		}
		$os_ver_parts = preg_split('@\.@',$os_ver);

		$loader_sfix = (($os_code == 'win') ? 'dll' : 'so');
		$file = "ioncube_loader_${os_code}_${php_major_version}.${loader_sfix}";

		if ($os_code == 'win') {
			$os_name = 'Windows';
			$file_ts = $file;
			$os_name_qual = 'Windows';
		} else {
			$os_names = array_keys($os_variants);
			if (count($os_variants) > 1) {
				$parts = explode(" ",$os_names[0]);
				$os_name = $parts[0];
				$os_name_qual = $os_name . ' ' . $os_ver_parts[0] . '.' . $os_ver_parts[1];
			} else {
				$os_name = $os_names[0];
				$os_name_qual = $os_name;
			}
			$file_ts = "ioncube_loader_${os_code}_${php_major_version}_ts.${loader_sfix}";
		}

		return array(
			'uname'      =>  $un,
			'arch'       =>  $arch,
			'oscode'     =>  $os_code,
			'osname'     =>  $os_name,
			'osnamequal' =>  $os_name_qual,
			'osvariants' =>  $os_variants,
			'osver'      =>  $os_ver,
			'osver2'     =>  $os_ver_parts,
			'file'       =>  $file,
			'file_ts'    =>  $file_ts,
			'wordsize'   =>  $wordsize
		);
	}

	function get_loaderinfo()
	{
		static $loader;

		$sessid=session_id();
		if(!empty($sessid)){
			if (isset($_SESSION['required_loader']) && !empty($_SESSION['required_loader'])) {
				return $_SESSION['required_loader'];
			}
		}
		if (empty($loader)) {
			$loader = $this->required_loader();
		}
		if(!empty($sessid) && !empty($loader)){
			$_SESSION['required_loader']=$loader;
		}
		return $loader;
	}

	function is_ms_windows()
	{
		$loader_info = $this->get_loaderinfo();
		return ($loader_info['oscode'] == 'win');
	}

	function selinux_is_enabled()
	{
		$sessid=session_id();
		if(!empty($sessid)){
			if (isset($_SESSION['sestatus'])) {
				return $_SESSION['sestatus']?true:false;
			}
		}

		$se_enabled = false;

		if (!$this->is_ms_windows()) {
			$cmd = @exe('sestatus');
			$se_enabled = preg_match('/enabled/i',$cmd);
		}
		if(!empty($sessid)){
			$_SESSION['sestatus']=$se_enabled?1:0;
		}

		return $se_enabled;
	}

	function is_safe_mode(){
		return ini_get('safe_mode')?true:false;
	}

	function is_disable_functions(){
		$disable_functions = ini_get('disable_functions');
		return !empty($disable_functions);
	}

	function is_open_basedir(){
		$open_basedir = ini_get('open_basedir');
		return !empty($open_basedir);
	}

//	function is_restricted_server()
//	{
//		return ($this->is_safe_mode() || $this->is_disable_functions() || $this->is_open_basedir() || $this->selinux_is_enabled());
//	}

	function function_is_disabled($fn_name)
	{
		$disabled_functions=explode(',',ini_get('disable_functions'));
		return in_array($fn_name, $disabled_functions);
	}

	function threaded_and_not_cgi()
	{
		$sys = $this->get_sysinfo();
		return($sys['THREAD_SAFE'] && !$sys['IS_CGI']);
	}

	function debug_build(){
		$sys = $this->get_sysinfo();
		return($sys['DEBUG_BUILD']);
	}

	function get_sysinfo()
	{
		static $sysinfo;

		$sessid=session_id();
		if(!empty($sessid)){
			if (isset($_SESSION['system_info']) && !empty($_SESSION['system_info'])) {
				return $_SESSION['system_info'];
			}
		}
		if (empty($sysinfo)) {
			$sysinfo = $this->ic_system_info();
		}
		if(!empty($sessid) && !empty($sysinfo)){
			$_SESSION['system_info']=$sysinfo;
		}
		return $sysinfo;
	}

	function ic_system_info()
	{
		$thread_safe = null;
		$debug_build = null;
		$php_ini_path = '';
		$php_ini_dir = '';
		$php_ini_add = '';
		$is_supported_compiler = true;
		$php_compiler = $this->is_ms_windows()?'VC6':'';

		ob_start();
		phpinfo(INFO_GENERAL);
		$php_info = ob_get_contents();
		ob_end_clean();

		$breaker = (php_sapi_name() == 'cli')?'\n':'</tr>';
		$lines = explode($breaker,$php_info);
		foreach ($lines as $line) {
			if (preg_match('/command/i',$line)) {
				continue;
			}

			if (preg_match('/thread safety/i', $line)) {
				$thread_safe = (preg_match('/(enabled|yes)/i', $line) != 0);
			}

			if (preg_match('/debug build/i', $line)) {
				$debug_build = (preg_match('/(enabled|yes)/i', $line) != 0);
			}

			if (preg_match('~configuration file.*(</B></td><TD ALIGN="left">| => |v">)([^ <]*)~i',$line,$match)) {
				$php_ini_path = $match[2];

				if (!@file_exists($php_ini_path)) {
					$php_ini_path = '';
				}
			}
			if (preg_match('~dir for additional \.ini files.*(</B></td><TD ALIGN="left">| => |v">)([^ <]*)~i',$line,$match)) {
				$php_ini_dir = $match[2];
				if (!@file_exists($php_ini_dir)) {
					$php_ini_dir = '';
				}
			}
			if (preg_match('~additional \.ini files parsed.*(</B></td><TD ALIGN="left">| => |v">)([^ <]*)~i',$line,$match)) {
				$php_ini_add = $match[2];
			}
			if (preg_match('/compiler/i',$line)) {
				$supported_match = join('|',$this->supported_win_compilers());
				$is_supported_compiler = preg_match("/($supported_match)/i",$line);
				if (preg_match("/(VC[0-9]+)/i",$line,$match)) {
					$php_compiler = strtoupper($match[1]);
				} else {
					$php_compiler = '';
				}
			}
		}
		$is_cgi = strpos(php_sapi_name(),'cgi') !== false;
		$is_cli = strpos(php_sapi_name(),'cli') !== false;
		$cgi_cli = $is_cgi || $is_cli;

		$ss = $this->server_software_info();

		if (!$php_ini_path && function_exists('php_ini_loaded_file')) {
			$php_ini_path = php_ini_loaded_file();
			if ($php_ini_path === false) {
				$php_ini_path = '';
			}
		}
		if (!empty($php_ini_path)) {
			$real_path = realpath($php_ini_path);
			if (false !== $real_path) {
				$php_ini_path = $real_path;
			}
		}

		$php_ini_basename = basename($php_ini_path);

		return array(
			'THREAD_SAFE'        => $thread_safe,
			'DEBUG_BUILD'        => $debug_build,
			'PHP_INI'            => $php_ini_path,
			'PHP_INI_BASENAME'   => $php_ini_basename,
			'PHP_INI_DIR'        => $php_ini_dir,
			'PHP_INI_ADDITIONAL' => $php_ini_add,
			'PHPRC'              => getenv('PHPRC'),
			'CGI_CLI'            => $cgi_cli,
			'IS_CGI'             => $is_cgi,
			'IS_CLI'             => $is_cli,
			'PHP_COMPILER'       => $php_compiler,
			'SUPPORTED_COMPILER' => $is_supported_compiler,
			'FULL_SS'            => $ss['full'],
			'SS'                 => $ss['short']);
	}

	function supported_win_compilers()
	{
		static $win_compilers;

		$sessid=session_id();
		if(!empty($sessid)){
			if (isset($_SESSION['win_compilers']) && !empty($_SESSION['win_compilers'])) {
				return $_SESSION['win_compilers'];
			}
		}
		if (empty($win_compilers)) {
			$win_compilers = @unserialize(remote_file_contents(PHP_COMPILERS_URL));
			if(empty($win_compilers)){
				$win_compilers=$this->default_win_compilers();
			}
		}
		if(!empty($sessid) && !empty($win_compilers)){
			$_SESSION['win_compilers']=$win_compilers;
		}
		return $win_compilers;
	}

	function default_win_compilers(){
		return array('VC6','VC9');
	}

	function server_software_info()
	{
		$ss = array('full' => '','short' => '');
		$ss['full'] = $_SERVER['SERVER_SOFTWARE'];

		if (preg_match('/apache/i', $ss['full'])) {
			$ss['short'] = 'Apache';
		} else if (preg_match('/IIS/',$ss['full'])) {
			$ss['short'] = 'IIS';
		} else {
			$ss['short'] = '';
		}
		return $ss;
	}

	function not_dl(){
		return (!ini_get('enable_dl') || !function_exists('dl') || $this->function_is_disabled('dl'));
	}

	function phpver_and_extension_dir() {
		return ( $this->is_php_version_or_greater( 5, 2, 5 ) && $this->extension_dir() != '.' );
	}

//	function runtime_loading_is_possible() {
//		return ! ( $this->phpver_and_extension_dir() || $this->is_restricted_server() || $this->not_dl() || $this->threaded_and_not_cgi() );
//	}

	function extension_dir() {
		$extdir = ini_get( 'extension_dir' );
		if ( $extdir == './' || ( $extdir == '.\\' && $this->is_ms_windows() ) ) {
			$extdir = '.';
		}

		return $extdir;
	}

//	function extension_dir_path() {
//		return realpath( $this->extension_dir() );
//	}

	function php_version() {
		$v = explode( '.', PHP_VERSION );

		return array(
			'major'   => $v[0],
			'minor'   => $v[1],
			'release' => $v[2]
		);
	}

	function is_supported_php_version() {
		$v = $this->php_version();

		return ( ( ( $v['major'] == 4 ) && ( $v['minor'] >= 1 ) ) ||
		         ( ( $v['major'] == 5 ) && ( ( $v['minor'] >= 1 ) || ( $v['release'] >= 5 ) ) ) ||
		         $v['major'] == 7 );
	}

	function is_php_version_or_greater($major,$minor,$release = 0) {
		$version = $this->php_version();

		return ( $version['major'] > $major ||
		         ( $version['major'] == $major && $version['minor'] > $minor ) ||
		         ( $version['major'] == $major && $version['minor'] == $minor && $version['release'] >= $release ) );
	}

	function get_loader_name() {
		$u = php_uname();
//		$os     = substr( $u, 0, strpos( $u, ' ' ) );
		$os_key = strtolower( substr( $u, 0, 3 ) );

		$php_version = phpversion();
		$php_family  = substr( $php_version, 0, 3 );

		$loader_sfix = ( ( $os_key == 'win' ) ? '.dll' : '.so' );

		return "ioncube_loader_${os_key}_${php_family}${loader_sfix}";
	}

	function get_reqd_version($variants) {
		$exact_match      = false;
		$nearest_version  = 0;
		$loader_info      = $this->get_loaderinfo();
		$os_version       = $loader_info['osver2'][0] . '.' . $loader_info['osver2'][1];
		$os_version_major = $loader_info['osver2'][0];
		foreach ( $variants as $v ) {
			if ( $v == $os_version || ( is_int( $v ) && $v == $os_version_major ) ) {
				$exact_match     = true;
				$nearest_version = $v;
				break;
			} elseif ( $v > $os_version ) {
				break;
			} else {
				$nearest_version = $v;
			}
		}

		return ( array( $nearest_version, $exact_match ) );
	}

	function get_basename() {
		$loader               = $this->get_loaderinfo();
		$multiple_os_versions = false;
		if ( array_key_exists( 'osvariants', $loader ) && is_array( $loader['osvariants'] ) ) {
			$versions             = array_values( $loader['osvariants'] );
			$multiple_os_versions = ! empty( $versions[0] );
		}
		if ( $multiple_os_versions ) {
			$reqd_version = $this->get_reqd_version( $loader['osvariants'] );
			if ( $reqd_version[0] ) {
				$basename = LOADERS_PACKAGE_PREFIX . $loader['oscode'] . '_' . $reqd_version[0] . '_' . $loader['arch'];
			} else {
				$basename = "";
			}
		} else {
			$basename = LOADERS_PACKAGE_PREFIX . $loader['oscode'] . '_' . $loader['arch'];
		}

		return $basename;
	}

	function loader_download_instructions() {
		$basename = $this->get_basename();
		if ( $basename ) {
			$archives = array( 'zip', 'tar.gz', 'tar.bz2' );

			return $this->make_archive_list( $basename, $archives );
		} else {
			return 'ご利用のOSにマッチするローダーが存在しません。';
		}
	}

	function make_archive_list($basename,$archives_list = array(),$download_server = IONCUBE_DOWNLOADS_SERVER) {
		if ( empty( $archives_list ) ) {
			$archives_list = array( 'tar.gz', 'tar.bz2', 'zip', 'ipf.zip' );
		}

		$archive_list=array();
		foreach ( $archives_list as $a ) {
			$link_text      = ( $a == 'ipf.zip' ) ? 'MS Windows installer' : $a;
			$ext_sep        = ( $a == 'ipf.zip' ) ? '_' : '.';
			$archive_list[] = "<a href=\"$download_server/$basename$ext_sep$a\">$link_text</a>";
		}

		return make_list( $archive_list, "ul" );
	}

	function get_loader_targz_url($download_server = IONCUBE_DOWNLOADS_SERVER){
		$basename=$this->get_basename();
		if($basename){
			return $download_server.'/'.$basename.'.tar.gz';
		}else{
			return null;
		}
	}

	function loader_check($ext_name = LOADER_EXTENSION_NAME){
		return extension_loaded($ext_name);
	}

	function loader_check_page()
	{
		showHeader();
		echo '<h3>php.iniへのローダーの組み込みテスト</h3>';
		if($this->loader_check()){
			echo '<br><div class=msg><strong>組み込み成功</strong></div>';
		}else{
			echo '<br><div class=err><strong>組み込み失敗</strong></div><br>';
			$sys = $this->get_sysinfo();
			$os_info = php_uname();
			$php_version = phpversion();
			if(!env('HTTPS')){
				$url='http://'.env('HTTP_HOST').'/'.env('SCRIPT_NAME');
			}else{
				$url='https://'.env('HTTP_HOST').'/'.env('SCRIPT_NAME');
			}
			?>
            以下の点について確認をお願いします。
            <ul>
                <li><?php echo $this->get_loader_name(); ?>をご利用のサーバーの /usr/local/ioncube ディレクトリ以下
                    にアップロードしているか。

                <li><?php echo $sys['PHP_INI']?$sys['PHP_INI']:'php.ini'; ?> に以下の行が追加されているか。<br>

                    <strong>zend_extension = /usr/local/ioncube/<?php echo $this->get_loader_name(); ?></strong><br>

                <li>apache(httpd)を再起動したか。
            </ul>

            上記に該当しない場合、<a href=<?php echo MAIN_SITE_URL; ?>/inquiries/add target="_blank">こちらからお問い合わせください。</a><br>
            なお、お問い合わせの際は、以下の枠内の情報をあわせてご連絡ください。<br>

            <fieldset>
                <strong><?php echo sanitize($os_info); ?></strong><br>
                <strong><?php echo sanitize($php_version); ?></strong><br>
                <strong><?php echo sanitize($url); ?></strong><br>
                <pre><strong><?php echo sanitize(print_r($sys,true)); ?></strong></pre><br>
            </fieldset>
			<?php
		}
		showFooter();
	}

	function senyo_page(){
		$err=array();
		if(!is_array($this->get_loaderinfo())){
			$err[]='このプラットフォーム(OS)に対応するローダーが存在しないため、このサーバーでは利用できません。<br><a href=https://www.ioncube.com/loaders.php target=_blank>ローダーを設置できるプラットフォーム(OS)はこちらから確認できます。</a>';
			showError($err);
			exit;
		}
		$sys = $this->get_sysinfo();
		showHeader();
		?>
		<?php if($this->loader_check()): ?>
            <div class=msg>
                このサーバーにはすでにローダーが組み込まれています。<br>以下の作業は不要です。
            </div>
            <br>
		<?php endif; ?>

        <h3>php.iniへのローダーの組み込み方</h3>
        <ol>
            <li>以下のリンクよりローダーファイルをダウンロードしてください。(どの圧縮形式でもかまいません)<br>
                <br>
				<?php echo $this->loader_download_instructions(); ?>
                <br>
            <li>ご利用のサーバーの適当なディレクトリに ioncube ディレクトリを作成してください。<br>
                なお、この説明では、/usr/local 以下にioncubeディレクトリを作成することとします。
                違うディレクトリに作成する場合は、以下の説明の /usr/local を、あなたが決めたディレクトリに
                読み替えてください。
            <li>ダウンロードしたファイルを解凍し、すべてのファイルを
                ご利用のサーバの /usr/local/ioncube ディレクトリ以下にアップロードしてください。

            <li><?php echo $sys['PHP_INI']?$sys['PHP_INI']:'php.ini'; ?> を編集して以下の行を追加してください。<br>

                <strong>zend_extension = /usr/local/ioncube/<?php echo $this->get_loader_name(); ?></strong><br>

            <li>apache(httpd)を再起動してください。
            <li><a href="<?php echo INSTALLER_PHP; ?>?act=senyo_test" target=_blank>ココ</a>をクリックしてローダーの動作テストをお願いします。
        </ol>
        <br>


        <a href="#" onclick="showHide('SH-003');return false;">※使えるネットをご利用の場合は、こちらをご覧ください</a><br>
        <div id="SH-003" style="display: none">
            <ol>
                <li>以下のリンクよりローダーファイルをダウンロードしてください。(どの圧縮形式でもかまいません)<br>
                    <br>
					<?php echo $this->loader_download_instructions(); ?>
                    <br>
                <li>ご利用のサーバーのコントロールパネル「PLESK」での操作となります。<br>
                    Virtuozzoのファイルマネージャー（File Manager）にアクセスし、 /usr/local/ のディレクトリ以下に ioncube ディレクトリを作成し、
                    ダウンロードしたファイルを解凍し、全てアップロードしてください。

                <li>ご利用のサーバーのコントロールパネル「PLESK」での操作となります。<br>
                    Virtuozzoのファイルマネージャー（File Manager）にアクセスし、 /etc/ 以下のディレクトリに存在するphp.iniの内容末に、以下の行を追加してください。<br>

                    <strong>zend_extension = /usr/local/ioncube/<?php echo $this->get_loader_name(); ?></strong><br>

                <li>ご利用のサーバーのコントロールパネル「PLESK」での操作となります。<br>
                    Virtuozzoのファイルマネージャー（File Manager）にアクセスし、
                    表示された画面上の「コンテナの再起動」をクリックしてください。
                    再起動が開始されます。
                <li><a href="<?php echo INSTALLER_PHP; ?>?act=senyo_test" target=_blank>ココ</a>をクリックしてローダーの動作テストをお願いします。
            </ol>
            <br>
        </div>

		<?php
		showFooter();
	}
}

class mailsoft {
	var $err=array();
	var $db=null;

	function get_error(){
		return 	$this->err;
	}

	function regist($result=20,$name='no name',$servertype=0) {
		$key=time();
		$data=array(
			'n'=>$name,
			'o'=>substr(php_uname(),0,strpos(php_uname(),' ')),
			'v'=>phpversion(),
			'i'=>gethostbyname(php_uname('n')),
			's'=>php_uname('n'),
			'r'=>$result,
			't'=>$servertype,
		);
		$hash=md5($key.serialize($data));
		$vars=urlencode(serialize(array('key'=>$key,'data'=>$data,'hash'=>$hash)));
		$regurl=sprintf(REG_URL,$vars);
		$re=remote_file_contents($regurl);
		return ($re!='' && $re==0)?false:true;
	}

	function setDir($params){
		if(isset($params['url']['dir'])){
			$dirname=$params['url']['dir'];
			if(!preg_match("/^[0-9a-zA\-]+$/",$dirname)) {
				$this->err[]='ディレクトリ名は半角英数字にしてください。';
				return false;
			}
			$_SESSION['dirname']=$dirname;
		}else{
			$_SESSION['dirname']=SOFT_DIR_NAME;
		}
		return true;
	}

	function checkParm()
	{
		$this->err=array();
		clearstatcache();
		if($_SESSION['dirname'] == '.'){
			$parm=substr(sprintf('%o', fileperms($_SESSION['dirname'])), -3);
			if($parm!='777')
			{
				$this->err[]='このファイルを設置したフォルダのパーミッションを777に変更してください。<br>修正後、<a href='.INSTALLER_PHP.'?dir='.$_SESSION['dirname'].'>こちら</a>から再度やりなおしてください。';
				return false;
			}
		}else{
			if(!file_exists($_SESSION['dirname'])){
				if(!@mkdir($_SESSION['dirname'], 0755)){
					$this->err[]='このファイルを設置したフォルダに '.$_SESSION['dirname'].' というフォルダを作成し、パーミッションを777に変更してください。<br>修正後、<a href='.INSTALLER_PHP.'?dir='.$_SESSION['dirname'].'>こちら</a>から再度やりなおしてください。';
					return false;
				}
			}else{
				$parm=substr(sprintf('%o', fileperms($_SESSION['dirname'])), -3);
				if($parm!='777')
				{
					$this->err[]='このファイルと同じ階層にある「'.$_SESSION['dirname'].'」というフォルダのパーミッションを777に変更してください。<br>修正後、<a href='.INSTALLER_PHP.'?dir='.$_SESSION['dirname'].'>こちら</a>から再度やりなおしてください。';
					return false;
				}
			}
		}
		return true;
	}

	function checkEnv(){
		$this->err=array();
		$loader = new loader();

		if(!$loader->is_supported_php_version()){
			$this->err[]='PHPのバージョンが要件を満たしていないため、このサーバーでは利用できません。<br><a href=https://www.ioncube.com/loaders.php target=_blank>ローダーを設置できるPHPのバージョンはこちらから確認できます。</a>';
		}
		if(!is_array($loader->get_loaderinfo())){
			$this->err[]='このプラットフォーム(OS)に対応するローダーが存在しないため、このサーバーでは利用できません。<br><a href=https://www.ioncube.com/loaders.php target=_blank>ローダーを設置できるプラットフォーム(OS)はこちらから確認できます。</a>';
		}
		if($loader->is_ms_windows()){
			$this->err[]='プラットフォーム(OS)がWindows系のため、このサーバーでは利用できません。';
		}
		if($loader->is_safe_mode()){
			$this->err[]='PHPのsafe_modeオプションがoffでないため、このサーバーでは利用できません。<br>php.iniを修正できる場合は修正し、apache(httpd)を再起動してください。修正できない場合は、safe_modeオプションをoffにする方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。';
		}
		if(!function_exists('mb_detect_encoding')){
			$this->err[]='PHPでmb_string関係の関数を利用できないため、このサーバーでは利用できません。<br>ご利用のサーバーのサーバー管理者にご相談ください。';
		}
		if(!function_exists('mysqli_connect')){
			$this->err[]='PHPでmysql関係の関数を利用できないため、このサーバーでは利用できません。<br>ご利用のサーバーのサーバー管理者にご相談ください。';
		}
		if($loader->debug_build()){
			$this->err[]='PHPがdebug buildのため、このサーバーでは利用できません。<br>ご利用のサーバーのサーバー管理者にご相談ください。';
		}
		return count($this->err)?false:true;
	}

	function showInputPhpPath($err=null){
		$phppath=get_php_path();
		if(!isset($_SESSION['loader_exist'])){
			$loader = new loader();
			$_SESSION['loader_exist']=$loader->loader_check()?1:0;
		}
		showHeader();
		?>
        <script type="text/javascript">
            <!--
            function ChangeSelection(form, selection) {
                form.servername.value = selection.value;
                if(selection.value==='さくらインターネット'){
                    form.phppath.value = '/usr/local/bin/php';
                }else if(selection.value==='CORESERVER(コアサーバー)'){
                    form.phppath.value = '/usr/local/bin/php';
                }else if(selection.value==='使えるネット'){
                    form.phppath.value = '/usr/bin/php';
                }else{
                    form.phppath.value = '<?php echo $phppath; ?>';
                }
            }
            //-->
        </script>

        <h3>レンタルサーバー情報</h3>

		<?php if($err){ echo '<div class=err>エラー'.make_list($err,'ul').'</div>'; } ?>

        このソフトを設置するレンタルサーバー、サーバー種別を選択してください。
        <br>

        <form method="post" action="<?php echo INSTALLER_PHP; ?>">
            <input type="hidden" name="act" value="input">

            <table>
                <tr>
                    <td style="text-align:left;">レンタルサーバー：</td>
                    <td style="text-align:left;">
                        <select name=servername_list onChange="ChangeSelection(this.form, this);">
                            <option value="">選択してください
                            <option value="WADAX">WADAX</option>
                            <option value="エックスサーバー">エックスサーバー</option>
                            <option value="さくらインターネット">さくらインターネット</option>
                            <option value="使えるネット">使えるネット</option>
                        </select><input type="text" name="servername" value="<?php echo (isset($_SESSION['servername']) && !empty($_SESSION['servername']))?sanitize($_SESSION['servername']):''; ?>" size="30" /><br>
                        選択肢にご利用のレンタルサーバーがない場合は、名称をご記入ください。
                    </td>
                </tr>
                <tr>
                    <td style="text-align:left;">サーバー種別：</td>
                    <td style="text-align:left;">
                        <select name="servertype">
                            <option label="共用サーバ" value="0" <?php echo (!isset($_SESSION['servertype']) || (isset($_SESSION['servertype']) && $_SESSION['servername']==0))?'selected="selected"':''; ?>>共用サーバ</option>
                            <option label="専用サーバ" value="1" <?php echo (isset($_SESSION['servertype']) && $_SESSION['servername']==1)?'selected="selected"':''; ?>>専用サーバ</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td style="text-align:left;">PHPのパス：</td>
                    <td style="text-align:left;"><input name="phppath" value="<?php echo (isset($_SESSION['phppath']) && !empty($_SESSION['phppath']))?sanitize($_SESSION['phppath']):$phppath; ?>"><br></td>
                </tr>
            </table>


            <h3>ローダー</h3>

			<?php if($_SESSION['loader_exist']==1): ?>
                <div class=msg>
                    このサーバにはすでにローダーが組み込まれています。
                </div>
                <input type="hidden" name="loadertype" value="1">

			<?php else: ?>
                ローダーの組み込み方を選択してください。
                <br>

                <table>
                    <tr>
                        <td style="text-align:left;">組み込み方：</td>
                        <td style="text-align:left;">
                            <select name="loadertype">
                                <option value="0" <?php echo (isset($_SESSION['loadertype']) && $_SESSION['loadertype']==0)?'selected="selected"':''; ?>>動的に組み込む</option>
                                <option value="1" <?php echo (!isset($_SESSION['loadertype']) || (isset($_SESSION['loadertype']) && $_SESSION['loadertype']==1))?'selected="selected"':''; ?>>php.iniに組み込む</option>
                            </select>
                        </td>
                    </tr>
                </table>

                <a href="#" onclick="showHide('SH-002');return false;">※php.iniに組み込む場合は必ずご覧ください</a><br>
                <div id="SH-002" style="display: none">
					<?php echo SOFT_NAME; ?>では、PHPスクリプトの最適化のため、<a href=https://www.ioncube.com/loaders.php target=_blank>ローダー</a>
                    を必要とします。<br>
                    ローダーについては、PHPスクリプトから動的に読み込む方法と、php.iniに設定する
                    方法がございます。<br>
                    サーバ負荷を考えると、php.iniに設定するほうがよいと思いますので、専用サーバやVPSなど
                    php.iniを修正できる場合は、php.iniを修正する方法をおすすめします。<br>
                    <a href="<?php echo INSTALLER_PHP; ?>?act=senyo" target=_blank>php.iniへのローダーの組み込み方</a>
                    <br>
                </div>
			<?php endif; ?>

            <br>


            <input type=submit value="次へ ≫">

        </form>
		<?php
		showFooter();
	}

	function checkInputPhpPath($params)
	{
		$loader = new loader();
		$this->err=array();
		if(empty($params['form']['servername']))
		{
			$this->err[]='レンタルサーバーを選択してください。';
		}
		if($params['form']['servertype']!=0 && $params['form']['servertype']!=1)
		{
			$this->err[]='サーバー種別を正しく選択してください。';
		}
		if(empty($params['form']['phppath']))
		{
			$this->err[]='PHPのパスを記入してください。';
		}else{
			$realpath=dirname(__FILE__).'/'.INSTALLER_PHP;
			$var=urlencode('act=cli');
			$cmd=sprintf('SCRIPT_FILENAME="%s" QUERY_STRING="%s" %s -f %s',$realpath,$var,$params['form']['phppath'],$realpath);
			$re=exe($cmd);
			if(preg_match("/RESULT: (.*)/",$re,$matches)){
				$re=unserialize($matches[1]);
				if(isset($re['err'])){
					foreach($re['err'] as $err)	{
						if($err=='php_version'){
							$this->err[]='コマンドライン版PHPのバージョンが要件を満たしていないため、このサーバーでは利用できません。<br><a href=https://www.ioncube.com/loaders.php target=_blank>ローダーを設置できるPHPのバージョンはこちらから確認できます。</a>';
						}else if($err=='safe_mode'){
							$this->err[]='コマンドライン版PHPのsafe_modeオプションがoffでないため、このサーバーでは利用できません。<br>php.iniを修正できる場合は修正し、apache(httpd)を再起動してください。修正できない場合は、safe_modeオプションをoffにする方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。';
						}else if($err=='mb_detect_encoding'){
							$this->err[]='コマンドライン版PHPでmb_string関係の関数を利用できないため、このサーバーでは利用できません。<br>ご利用のサーバーのサーバー管理者にご相談ください。';
						}else if($err=='mysqli_connect'){
							$this->err[]='コマンドライン版PHPでmysql関係の関数を利用できないため、このサーバーでは利用できません。<br>ご利用のサーバーのサーバー管理者にご相談ください。';
						}else if($err=='debug_build'){
							$this->err[]='コマンドライン版PHPがdebug buildのため、このサーバーでは利用できません。<br>ご利用のサーバーのサーバー管理者にご相談ください。';
						}
						if(!$params['form']['loadertype']){
							if($err=='disable_functions'){
								$this->err[]='コマンドライン版PHPのdisable_functionsオプションが設定されているため、このサーバーでは利用できません。<br>php.iniを修正できる場合は修正し、apache(httpd)を再起動してください。修正できない場合は、disable_functionsオプションをNULにする方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。<br>このオプションの設定変更は不可だけど、php.iniの修正は可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
							}else if($err=='open_basedir'){
								$this->err[]='コマンドライン版PHPのopen_basedirオプションが設定されているため、このサーバーでは利用できません。<br>php.iniを修正できる場合は修正し、apache(httpd)を再起動してください。修正できない場合は、open_basedirオプションをNULLにする方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。<br>このオプションの設定変更は不可だけど、php.iniの修正は可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
							}else if($err=='dl'){
								$this->err[]='コマンドライン版PHPのenable_dlオプションがonでないか、dl関数を利用できないため、このサーバーでは利用できません。<br>dl関数を利用できるようにする方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。<br>このオプションの設定変更は不可だけど、php.iniの修正は可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
							}else if($err=='extension_dir'){
								$this->err[]='コマンドライン版PHPのバージョンが5.2.5以上で、extension_dir="./"となっていないため、このサーバーでは利用できません。<br>php.iniを修正できる場合は修正し、apache(httpd)を再起動してください。修正できない場合は、extension_dirオプションを変更する方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。<br>このオプションの設定変更は不可だけど、php.iniの修正は可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
							}
						}
					}
				}
				if(!$params['form']['loadertype']){
					$phpver=$loader->php_version();
					if($re['ver']['major']!=$phpver['major'] || ($re['ver']['major']==5 && $re['ver']['minor']!=$phpver['minor'])){
						if($params['form']['servername']=='SPPD'){
							$this->err[]='モジュール版PHP('.join('.',$phpver).')とコマンドライン版PHP('.join('.',$re['ver']).')のバージョンが違うので、このサーバではご利用できません。<br>SPPDでしたらPHPのパスに /usr/local/php5/bin/php もお試しください。<br>どうしてもこのエラーがでる場合、モジュール版PHPとコマンドライン版PHPのバージョンを一致させる方法がないか、ご利用のサーバーのサーバー管理者にお問い合わせください。';
						}else{
							$this->err[]='モジュール版PHP('.join('.',$phpver).')とコマンドライン版PHP('.join('.',$re['ver']).')のバージョンが違うので、このサーバではご利用できません。<br>どうしてもこのエラーがでる場合、モジュール版PHPとコマンドライン版PHPのバージョンを一致させる方法がないか、ご利用のサーバーのサーバー管理者にお問い合わせください。';
						}
					}
				}
			}else{
				if($params['form']['servername']=='エックスサーバー'){
					$this->err[]='PHPのパスが正しいか確認してください。<br>エックスサーバーでしたら /usr/local/bin/php /usr/bin/php /usr/bin/php5 もお試しください。<br>不明な場合は、ご利用のサーバーのサーバー管理者にPHPのパスをお問い合わせください。<br>PHPのパスが正しい場合、コマンドライン版PHPが利用可能か、ご利用のサーバーのサーバー管理者にお問い合わせください。';
				}else if($params['form']['servername']=='SPPD'){
					$this->err[]='PHPのパスが正しいか確認してください。<br>SPPDでしたら /usr/local/php5/bin/php もお試しください。<br>不明な場合は、ご利用のサーバーのサーバー管理者にPHPのパスをお問い合わせください。<br>PHPのパスが正しい場合、コマンドライン版PHPが利用可能か、ご利用のサーバーのサーバー管理者にお問い合わせください。';
				}else{
					$this->err[]='PHPのパスが正しいか確認してください。<br>不明な場合は、ご利用のサーバーのサーバー管理者にPHPのパスをお問い合わせください。<br>PHPのパスが正しい場合、コマンドライン版PHPが利用可能か、ご利用のサーバーのサーバー管理者にお問い合わせください。';
				}
			}
		}

		if(!$params['form']['loadertype']){
			if($loader->is_disable_functions()){
				$this->err[]='PHPのdisable_functionsオプションが設定されているため、このサーバーでは利用できません。<br>php.iniを修正できる場合は修正し、apache(httpd)を再起動してください。修正できない場合は、disable_functionsオプションをNULにする方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。<br>このオプションの設定変更は不可だけど、php.iniの修正は可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
			}
			if($loader->is_open_basedir()){
				$this->err[]='PHPのopen_basedirオプションが設定されているため、このサーバーでは利用できません。<br>php.iniを修正できる場合は修正し、apache(httpd)を再起動してください。修正できない場合は、open_basedirオプションをNULLにする方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。<br>このオプションの設定変更は不可だけど、php.iniの修正は可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
			}
			if($loader->selinux_is_enabled()){
				$this->err[]='selinuxが有効なため、このサーバーでは利用できません。<br>ご利用のサーバーのサーバー管理者にご相談ください。<br>php.iniの修正が可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
			}
			if($loader->not_dl()){
				$this->err[]='PHPのenable_dlオプションがonでないか、dl関数を利用できないため、このサーバーでは利用できません。<br>dl関数を利用できるようにする方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。<br>このオプションの設定変更は不可だけど、php.iniの修正は可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
			}
			if($loader->threaded_and_not_cgi()){
				$this->err[]='PHPがthread safesがenableでapiがcgi版なため、このサーバーでは利用できません。<br>ご利用のサーバーのサーバー管理者にご相談ください。<br>php.iniの修正が可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
			}
			if($loader->phpver_and_extension_dir()){
				$this->err[]='PHPのバージョンが5.2.5以上で、extension_dir="./"となっていないため、このサーバーでは利用できません。<br>php.iniを修正できる場合は修正し、apache(httpd)を再起動してください。修正できない場合は、extension_dirオプションを変更する方法がないか、ご利用のサーバーのサーバー管理者にご相談ください。<br>このオプションの設定変更は不可だけど、php.iniの修正は可能な場合、<a href="'.INSTALLER_PHP.'?act=senyo" target=_blank>php.iniへのローダーの組み込み</a>をご検討ください。';
			}
		}

		$_SESSION['servername']=$params['form']['servername'];
		$_SESSION['servertype']=$params['form']['servertype'];
		$_SESSION['loadertype']=$params['form']['loadertype'];
		$_SESSION['phppath']=$params['form']['phppath'];
		return count($this->err)?false:true;
	}

	function showInputIdPw($err=null){
		showHeader();
		?>
        <h3>ソフト一式ダウンロード</h3>

		<?php if($err){ echo '<div class=err>エラー'.make_list($err,'ul').'</div>'; } ?>


        ソフト一式をダウンロードし、サーバに設置します。mail-neo.comのログイン情報を入力の上、よろしければ、以下の「次へ ≫」ボタンを押してください。
        <br><br>

        <form method="post" action="<?php echo INSTALLER_PHP; ?>">
            <input type="hidden" name="act" value="dl">
            メールアドレス<br>
            <input type="text" name="email"><br>
            パスワード<br>
            <input type="text" name="password"><br><br>

            <input type=submit value="次へ ≫">

        </form>
		<?php
		showFooter();
	}

	function delAll(){
		@unlink($_SESSION['dirname'].'/'.TAR_FILE);
		delTree($_SESSION['dirname'].'/'.SOURCE_DIR);
		delTree($_SESSION['dirname'].'/backend');
		delTree($_SESSION['dirname'].'/test');
		delTree($_SESSION['dirname'].'/img');
		delTree($_SESSION['dirname'].'/css');
		if(file_exists($_SESSION['dirname'].'/ioncube')){
			delTree($_SESSION['dirname'].'/ioncube');
		}
		if(file_exists($_SESSION['dirname'].'/js')){
			delTree($_SESSION['dirname'].'/js');
		}
		if(file_exists($_SESSION['dirname'].'/tmp/log')){
			delTree($_SESSION['dirname'].'/tmp/log');
		}
		foreach(scanEntireDir($_SESSION['dirname']) as $item){
			if ( (!strcmp($item, '.')) OR (!strcmp($item, '..')) OR (!strcmp($item, 'tmp'))) continue;
			@unlink($_SESSION['dirname'].'/'.$item);
		}
	}

	function fileSetting($params){
		$this->err=array();
		if(!preg_match('/^[0-9a-zA-Z_.+-]+@[0-9a-zA-Z-]+(?:\.[0-9a-zA-Z-]+)+$/',$params['form']['email'])){
			$this->err[]='メールアドレスは正しく記入してください。';
		}
		if(!preg_match("/^\w+$/",$params['form']['password'])){
			$this->err[]='パスワードは半角英数字で記入してください。';
		}
		$_SESSION['email']=$params['form']['email'];
		$_SESSION['password']=$params['form']['password'];
		if(count($this->err)){
			return false;
		}

		if(isset($_SESSION['file_setting']) && $_SESSION['file_setting']==1){
			return true;
		}

		$this->delAll();

		$match = explode('.', phpversion());
		$phpver = (int) sprintf('%d%02d%02d', $match[0], $match[1], intval($match[2]));
		if ($phpver < 50000) {
			$ver='php4';
		}else if ($phpver>=70000) {
			$ver='php7';
		}else if ($phpver>=50205) {
			$ver='php525';
		}else{
			$ver='php5';
		}

		$dlurl=sprintf(DL_URL,urlencode($params['form']['email']),$params['form']['password'],$ver);
//		$dlurl=sprintf(DL_URL,'freeneo','withad',$ver);

		if(!download($dlurl,$_SESSION['dirname'].'/'.TAR_FILE)){
			$this->err[]='ファイルのダウンロードに失敗しました。<br>'.MAIN_SITE_NAME.'会員ページのログイン情報に間違いがないか確認してください。<br>会員ページのログイン情報が不明な場合は<a href='.MAIN_SITE_URL.'/usrs/reminder/ target="_blank">コチラ</a>から確認してください。<br>もしログイン情報に間違いない場合、しばらくしてからやりなおしてください。';
			return false;
		}

		if(!file_exists($_SESSION['dirname'].'/'.TAR_FILE)){
			$this->err[]='ファイルのダウンロードに失敗しました。しばらくしてからやりなおしてください。';
			return false;
		}

		if(filesize($_SESSION['dirname'].'/'.TAR_FILE)<100){
			$this->err[]=MAIN_SITE_NAME.'会員ページのログイン情報が正しくありません。<br>会員ページのログイン情報が不明な場合は<a href='.MAIN_SITE_URL.'/usrs/reminder/ target="_blank">コチラ</a>から確認してください。';
			return false;
		}

		if($_SESSION['dirname'] == '.'){
			$cmd='tar -zxf '.TAR_FILE.' '.SOURCE_DIR;
			$cmd2='gzip -d '.TAR_FILE.'; tar -xf '.TAR_FILE2;
		}else{
			$cmd='cd '.$_SESSION['dirname'].'; tar -zxf '.TAR_FILE.' '.SOURCE_DIR;
			$cmd2='cd '.$_SESSION['dirname'].'; gzip -d '.TAR_FILE.'; tar -xf '.TAR_FILE2;
		}
		exe($cmd);

		if(!file_exists($_SESSION['dirname'].'/'.SOURCE_DIR)){
			exe($cmd2);
			if(!file_exists($_SESSION['dirname'].'/'.SOURCE_DIR)){
				$this->err[]='ファイルの展開に失敗しました。ファイル取得に失敗した可能性があります。しばらくしてからやりなおしてください。';
				return false;
			}
		}

		@unlink($_SESSION['dirname'].'/'.TAR_FILE);
		@unlink($_SESSION['dirname'].'/'.TAR_FILE2);

		dircopy($_SESSION['dirname'].'/'.SOURCE_DIR,$_SESSION['dirname']);
		delTree($_SESSION['dirname'].'/'.SOURCE_DIR);

		$filename =$_SESSION['dirname'].'/'.VERFILE;
		if ($fp = @fopen($filename, 'w'))
		{
			$config_data = date("Y-m-d");
			@fputs($fp, $config_data, strlen($config_data));
			fclose($fp);
		}

		if(!file_exists($_SESSION['dirname'].'/backend/tmp/smarty/templates_c/')){
		    mkdir($_SESSION['dirname'].'/backend/tmp/smarty/templates_c/', 0777);
		}
		chmod($_SESSION['dirname'].'/backend/lib/config/database.php', 0666);
		chmod($_SESSION['dirname'].'/backend/mail/bin/regist.cgi', 0755);
		chmod($_SESSION['dirname'].'/backend/mail/bin/sender.cgi', 0755);
		chmod($_SESSION['dirname'].'/backend/tmp/smarty/cache/', 0777);
		chmod($_SESSION['dirname'].'/backend/tmp/smarty/templates_c/', 0777);
		chmod($_SESSION['dirname'].'/backend/tmp/pseudo-cron/cronjobs/', 0777);
		chmod($_SESSION['dirname'].'/backend/tmp/data/', 0777);
		chmod($_SESSION['dirname'].'/tmp/log/', 0777);

		$loader = new loader();
		$sys = $loader->get_sysinfo();
		if($sys['IS_CGI']){
			copy($_SESSION['dirname'].'/backend/mail/src/sender.php',$_SESSION['dirname'].'/backend/mail/bin/sender.cgi');
			copy($_SESSION['dirname'].'/backend/mail/src/regist.php',$_SESSION['dirname'].'/backend/mail/bin/regist.cgi');
			rename($_SESSION['dirname'].'/backend/mail/bin/sender.cgi',$_SESSION['dirname'].'/backend/mail/bin/sender.php');
			rename($_SESSION['dirname'].'/backend/mail/bin/regist.cgi',$_SESSION['dirname'].'/backend/mail/bin/regist.php');
		}

		if(MAIN_SITE_URL == 'https://www.mail-neo2.com'){
			touch($_SESSION['dirname'].'/backend/lib/config/gmo_vps.php');
		}

		$_SESSION['file_setting']=1;
		return true;
	}

	function showInput($err=null){
		showHeader();
		?>
        <h3>管理者ログインパスワード</h3>

		<?php if($err){ echo '<div class=err>エラー'.make_list($err,'ul').'</div>'; } ?>


        このソフトにログインする際に必要となるパスワードを設定してください。
        <br>

        <form method="post" action="<?php echo INSTALLER_PHP; ?>">
            <input type="hidden" name="act" value="setdb">

            <table>
                <tr>
                    <td style="text-align:left;">管理者ログインパスワード：</td>
                    <td style="text-align:left;"><input name="loginpassword" value="<?php echo (isset($_SESSION['loginpassword']) && !empty($_SESSION['loginpassword']))?sanitize($_SESSION['loginpassword']):''; ?>"><br>半角英数字4～12字で、ご希望のパスワードを設定してください。</td>
                </tr>
            </table>


            <h3>データベース情報</h3>


            データベースの設定情報を入力してください。
            <br>

            <table>
                <tr>
                    <td style="text-align:left;">1)サーバー/ホスト：</td>
                    <td style="text-align:left;"><input name="host" value="<?php echo (isset($_SESSION['host']) && !empty($_SESSION['host']))?sanitize($_SESSION['host']):'localhost'; ?>"><br>ポート番号を指定する場合は「localhost:3306」のように記述してください。</td>
                </tr>
                <tr>
                    <td style="text-align:left;">2)データベース名：</td>
                    <td style="text-align:left;"><input name="database" value="<?php echo (isset($_SESSION['database']) && !empty($_SESSION['database']))?sanitize($_SESSION['database']):''; ?>"><br>すでに存在している場合、一旦削除され、新規に作成されます。</td>
                </tr>
                <tr>
                    <td style="text-align:left;">3)ユーザー名：</td>
                    <td style="text-align:left;"><input name="dbuser" value="<?php echo (isset($_SESSION['dbuser']) && !empty($_SESSION['dbuser']))?sanitize($_SESSION['dbuser']):''; ?>"><br>データベース作成や権限を与えることができるユーザ名を指定してください。</td>
                </tr>
                <tr>
                    <td style="text-align:left;">4)上記ユーザーのパスワード：</td>
                    <td style="text-align:left;"><input name="dbpassword" value="<?php echo (isset($_SESSION['dbpassword']) && !empty($_SESSION['dbpassword']))?sanitize($_SESSION['dbpassword']):''; ?>"></td>
                </tr>
            </table>
            <br>

            データベースを上書きするかどうかを選択してください。
            <br>

            <table>
                <tr>
                    <td style="text-align:left;">データベースを上書きするか：</td>
                    <td style="text-align:left;">
                        <select name="dbupdate">
                            <option label="はい" value="1" <?php echo (!isset($_SESSION['dbupdate']) || (isset($_SESSION['dbupdate']) && $_SESSION['dbupdate']==1))?'selected="selected"':''; ?>>はい</option>
                            <option label="いいえ" value="0" <?php echo (isset($_SESSION['dbupdate']) && $_SESSION['dbupdate']==0)?'selected="selected"':''; ?>>いいえ</option>
                        </select><br>
                        通常は「はい」を選んでください。<br>
                        PHPのバージョンアップの影響でログインできなくなった場合など、<br>
                        データベースの内容を上書きしたくない場合は、「いいえ」を選んでください。<br>
                    </td>
                </tr>
            </table>




            <input type=submit value="次へ ≫">

        </form>
		<?php
		showFooter();
	}

	function setDb($params){
		$this->err=array();
		if(!preg_match("/^\w+$/",$params['form']['loginpassword']) || strlen($params['form']['loginpassword'])>12 || strlen($params['form']['loginpassword'])<4)
		{
			$this->err[]='管理者ログインパスワードは半角英数字4字から12字までで記入してください。';
		}
		if(empty($params['form']['host']))
		{
			$this->err[]='サーバー/ホストを入力してください。';
		}
		if(empty($params['form']['database']))
		{
			$this->err[]='データベース名を入力してください。';
		}
		if(empty($params['form']['dbuser']))
		{
			$this->err[]='ユーザー名を入力してください。';
		}
		if(empty($params['form']['dbpassword']))
		{
			$this->err[]='上記ユーザーのパスワードを入力してください。';
		}
		$_SESSION['loginpassword']=$params['form']['loginpassword'];
		$_SESSION['host']=$params['form']['host'];
		$_SESSION['database']=$params['form']['database'];
		$_SESSION['dbuser']=$params['form']['dbuser'];
		$_SESSION['dbpassword']=$params['form']['dbpassword'];
		$_SESSION['dbupdate']=$params['form']['dbupdate'];
		if(count($this->err)){
			return false;
		}

		$this->db=new database();

		if(!$this->db->connect($params['form']['host'],$params['form']['dbuser'],$params['form']['dbpassword']))
		{
			$this->err[]='ホストに接続できませんでした。<br>サーバー/ホスト、ユーザ名、上記ユーザーのパスワードに間違いがないか確認してください。<br>間違いがない場合、ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
			return false;
		}

		$query = "SELECT VERSION();";
		if(!$this->db->execute($query))
		{
			$this->err[]="SQL実行時に問題が発生しました。<br>(<small>" . sanitize($query) . "</small>)<br>".$this->db->get_error().'<br>ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
			$this->db->close();
			return false;
		}
		$mysql_version=$this->db->fetchResult();
		$match = explode('.', $mysql_version);
		$mysql_int_version = (int) sprintf('%d%02d', $match[0], $match[1]);

		if($mysql_int_version>400)
		{
			$query="SET NAMES utf8";
			if(!$this->db->execute($query))
			{
				$this->err[]="SQL実行時に問題が発生しました。<br>(<small>" . sanitize($query) . "</small>)<br>".$this->db->get_error().'<br>ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
				$this->db->close();
				return false;
			}
		}

		if (!$this->db->select_db($params['form']['database'])) {
			if($params['form']['dbupdate']){
				$query = sprintf("CREATE DATABASE `%s`;",$this->db->escape($params['form']['database']));
				if (!$this->db->execute($query)) {
					$this->err[]='データベースを作成できませんでした。<br>データベースの作成権限のあるユーザ名を入力してください。<br>'.$this->db->get_error().'<br>間違いがない場合、ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
					$this->db->close();
					return false;
				}

				if (!$this->db->select_db($params['form']['database'])) {
					$this->err[]='データベースに接続できませんでした。<br>サーバー/ホスト、データベース名、ユーザ名、上記ユーザーのパスワードに間違いがないか、アクセス権限は付与されているか確認してください。<br>'.$this->db->get_error().'<br>間違いがない場合、ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
					$this->db->close();
					return false;
				}
			}else{
				$this->err[]='データベースに接続できませんでした。<br>サーバー/ホスト、データベース名、ユーザ名、上記ユーザーのパスワードに間違いがないか、アクセス権限は付与されているか確認してください。<br>'.$this->db->get_error().'<br>間違いがない場合、ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
				$this->db->close();
				return false;
			}
		}else{
			if($params['form']['dbupdate']){
				$query = sprintf("DROP DATABASE `%s`;",$this->db->escape($params['form']['database']));
				if (!$this->db->execute($query)) {
					$tables=$this->db->get_tables();
					if ($tables===false) {
						$this->err[]='テーブルリストを取得できませんでした。<br>データベースにアクセス権限のあるユーザ名を入力してください。<br>'.$this->db->get_error().'<br>間違いがない場合、ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
						$this->db->close();
						return false;
					}
					$query = "DROP TABLE IF EXISTS ".join(' , ', $tables).";";
					if (!$this->db->execute($query)) {
						$this->err[]='テーブルを削除できませんでした。<br>データベースの削除権限のあるユーザ名を入力してください。<br>'.$this->db->get_error().'<br>間違いがない場合、ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
						$this->db->close();
						return false;
					}
				}else{
					$query = sprintf("CREATE DATABASE `%s`;",$this->db->escape($params['form']['database']));
					if (!$this->db->execute($query)) {
						$this->err[]='データベースを作成できませんでした。<br>データベースの作成権限のあるユーザ名を入力してください。<br>'.$this->db->get_error().'<br>間違いがない場合、ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
						$this->db->close();
						return false;
					}

					if (!$this->db->select_db($params['form']['database'])) {
						$this->err[]='データベースに接続できませんでした。<br>サーバー/ホスト、データベース名、ユーザ名、上記ユーザーのパスワードに間違いがないか、アクセス権限は付与されているか確認してください。<br>'.$this->db->get_error().'<br>間違いがない場合、ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
						$this->db->close();
						return false;
					}
				}
			}
		}


		if($mysql_int_version>400){
			@unlink($_SESSION['dirname'].'/'.SQLDIR.'/init.sql');
		}else{
			@unlink($_SESSION['dirname'].'/'.SQLDIR.'/init_41.sql');
		}
		if($_SESSION['dirname'] == '.'){
			$path=str_replace("/".INSTALLER_PHP,"",env('SCRIPT_NAME'));
		}else{
			$path=str_replace("/".INSTALLER_PHP,"",env('SCRIPT_NAME')).'/'.$_SESSION['dirname'];
		}
		if(!env('HTTPS')){
			$siteurl='http://'.env('HTTP_HOST').$path;
		}else{
			$siteurl='https://'.env('HTTP_HOST').$path;
		}
		$_SESSION['siteurl']=$siteurl;

		if($params['form']['dbupdate']){
			$files=scanEntireDir($_SESSION['dirname'].'/'.SQLDIR);
			sort($files);
			foreach($files as $file){
				if ( (!strcmp($file, '.')) OR (!strcmp($file, '..')) ) continue;
				$filename = $_SESSION['dirname'].'/'.SQLDIR.'/'.$file;

				if(substr($file,-3)=='sql'){
					$fd = fopen ($filename, "r");
					$queries = fread ($fd, filesize ($filename));
					fclose ($fd);
					$queries = preg_split("/(;\n|;\r)/",$queries);

					foreach($queries as $query)
					{
						$query = trim($query);
						if ($query)
						{
							if(preg_match("/^--/",$query))
							{
								continue;
							}
							$query=@preg_replace("/--[^\n]+\n/","\n",$query);
							if(!$this->db->execute($query))
							{
								$this->err[]="SQL実行時に問題が発生しました。(<small>" . sanitize($query) . "</small>)<br>".$this->db->get_error().'<br>ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
								$this->db->close();
								return false;
							}
						}
					}
				}else if(substr($file,-3)=='php'){
					include($filename);
				}
			}

			$loader = new loader();
			$sys = $loader->get_sysinfo();
			if($_SESSION['dirname'] == '.'){
				if($sys['IS_CGI']){
					$sender_path=dirname(__FILE__).'/backend/mail/bin/sender.php';
					$register_path=dirname(__FILE__).'/backend/mail/bin/regist.php';
				}else{
					$sender_path=dirname(__FILE__).'/backend/mail/bin/sender.cgi';
					$register_path=dirname(__FILE__).'/backend/mail/bin/regist.cgi';
				}
			}else{
				if($sys['IS_CGI']){
					$sender_path=dirname(__FILE__).'/'.$_SESSION['dirname'].'/backend/mail/bin/sender.php';
					$register_path=dirname(__FILE__).'/'.$_SESSION['dirname'].'/backend/mail/bin/regist.php';
				}else{
					$sender_path=dirname(__FILE__).'/'.$_SESSION['dirname'].'/backend/mail/bin/sender.cgi';
					$register_path=dirname(__FILE__).'/'.$_SESSION['dirname'].'/backend/mail/bin/regist.cgi';
				}
			}

			$query = sprintf("insert into configs(sitename, siteurl, loginpassword, " .
			                 "sender_ln, sender_cmd, regist_cmd, servername, servertype) " .
			                 "values('%s','%s','%s','%s','%s','%s','%s','%s');",
				$this->db->escape('MY '. SOFT_NAME .' 独自メール配信ソフト'),
				$this->db->escape($siteurl),
				$this->db->escape($params['form']['loginpassword']),
				$this->db->escape($_SESSION['phppath']),
				$this->db->escape($sender_path),
				$this->db->escape($register_path),
				$this->db->escape($_SESSION['servername']),
				$this->db->escape($_SESSION['servertype']));
			if(!$this->db->execute($query))
			{
				$this->err[]='データベースに管理者ログインパスワード、サイトURLを登録できませんでした。<br>'.$this->db->get_error().'<br>ご利用されているサーバーのmysqlの負荷が高く、一時的に利用できないということも考えられます。この場合、しばらくしてからやり直してください。';
				return false;
			}
		}

		$this->db->close();

		$configWritten = 0;
		$filename =$_SESSION['dirname'].'/'.DBCONFFILE;
		if (@file_exists($filename) && is_writable($filename) && $fp = @fopen($filename, 'w'))
		{
			$config_data = "<" . "?php \n";
			$config_data .= "\n";
			$config_data .= "class DATABASE_CONFIG\n";
			$config_data .= "{\n";
			$config_data .= "	var \$default = array(\n";
			$config_data .= "		'driver' => 'mysql',\n";
			$config_data .= "		'connect' => 'mysql_connect',\n";
			$config_data .= "		'host' => '".$params['form']['host']."',\n";
			$config_data .= "		'login' => '".$params['form']['dbuser']."',\n";
			$config_data .= "		'password' => '".$params['form']['dbpassword']."',\n";
			$config_data .= "		'database' => '".$params['form']['database']."' \n";
			$config_data .= "	);\n";
			$config_data .= "}\n";
			$config_data .= "?" . ">";

			$result = @fputs($fp, $config_data, strlen($config_data));
			fclose($fp);
			if ($result)
			{
				$configWritten = 1;
			}
		}

		if(!$configWritten)
		{
			$this->err[]='設定をファイルに書き込めませんでした。<br>'.$_SESSION['dirname'].'/'.DBCONFFILE.' が存在していてパーミッションが666か確認してください。';
			return false;
		}
		chmod($_SESSION['dirname'].'/'.DBCONFFILE, 0644);
		return true;
	}

	function installLoader(){
		if(isset($_SESSION['install_loader']) && $_SESSION['install_loader']==1 && $this->checkLoader()){
			return true;
		}
		$this->err=array();
		$loader = new loader();
		$dlurl=$loader->get_loader_targz_url();
		if(empty($dlurl)){
			$this->err[]='ご利用のOSにマッチするローダーが存在しません。';
			return false;
		}

		$match = explode('.', phpversion());
		$phpver = (int) sprintf('%d%02d%02d', $match[0], $match[1], intval($match[2]));

		if($phpver>=50205){
			exe('rm -f '.$_SESSION['dirname'].'/ioncube_loader_*');
		}else{
			if(file_exists($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR)){
				delTree($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR);
			}
		}

		if(!download($dlurl,$_SESSION['dirname'].'/'.LOADER_TAR_FILE)){
			$this->err[]='ファイルのダウンロードに失敗しました。しばらくしてからやりなおしてください。';
			return false;
		}

		if(!file_exists($_SESSION['dirname'].'/'.LOADER_TAR_FILE)){
			$this->err[]='ファイルのダウンロードに失敗しました。しばらくしてからやりなおしてください。';
			return false;
		}

		if($_SESSION['dirname'] == '.'){
			$cmd='tar -zxf '.LOADER_TAR_FILE.' '.LOADER_SOURCE_DIR;
			$cmd2='gzip -d '.LOADER_TAR_FILE.'; tar -xf '.LOADER_TAR_FILE2.' '.LOADER_SOURCE_DIR;
		}else{
			$cmd='cd '.$_SESSION['dirname'].'; tar -zxf '.LOADER_TAR_FILE.' '.LOADER_SOURCE_DIR;
			$cmd2='cd '.$_SESSION['dirname'].'; gzip -d '.LOADER_TAR_FILE.'; tar -xf '.LOADER_TAR_FILE2.' '.LOADER_SOURCE_DIR;
		}
		exe($cmd);

		if(!file_exists($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR)){
			exe($cmd2);
			if(!file_exists($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR)){
				$this->err[]='ファイルの展開に失敗しました。ファイル取得に失敗した可能性があります。しばらくしてからやりなおしてください。';
				return false;
			}
		}

		@unlink($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.'/'.'ioncube-encoded-file.php');
		@unlink($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.'/'.'ioncube-loader-helper.php');
		@unlink($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.'/'.'loader-wizard.php');

		if($phpver>=50205){
			@rename($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.'/'.'LICENSE.txt',$_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.'/'.'ioncube_loader_LICENSE.txt');
			@rename($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.'/'.'README.txt',$_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.'/'.'ioncube_loader_README.txt');
			dircopy($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR,$_SESSION['dirname']);
			delTree($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR);

			$dir=dirname(__FILE__).'/'.$_SESSION['dirname'];
			$cmd=sprintf('cp %s/ioncube_loader_* %s/test/',$dir,$dir);
			exe($cmd);
			$cmd=sprintf('cp %s/ioncube_loader_* %s/backend/mail/bin/',$dir,$dir);
			exe($cmd);
		}

		@unlink($_SESSION['dirname'].'/'.LOADER_TAR_FILE);
		@unlink($_SESSION['dirname'].'/'.LOADER_TAR_FILE2);
		$_SESSION['install_loader']=1;
		return true;
	}

	function checkLoader() {
		if($_SESSION['dirname'] == '.'){
			$dir=dirname(__FILE__);
		}else{
			$dir=dirname(__FILE__).'/'.$_SESSION['dirname'];
		}
		@chmod($dir, 0755);

		$phpfile =$_SESSION['dirname'].'/test/ioncube-test.php';

		$path=str_replace(INSTALLER_PHP,"",env('SCRIPT_NAME')).$phpfile;
		if(!env('HTTPS')){
			$re=remote_file_contents('http://'.env('SERVER_NAME').$path);
		}else{
			$re=remote_file_contents('https://'.env('SERVER_NAME').$path);
		}
		$result= strpos($re,'IONCUBE LOADER TEST OK') !== false;
		@chmod($dir, 0777);
		return $result;
	}

	function showLoderErr(){
		$loader = new loader();
		$sys = $loader->get_sysinfo();
		$os_info = php_uname();
		$php_version = phpversion();
		if(!env('HTTPS')){
			$url='http://'.env('HTTP_HOST').'/'.env('SCRIPT_NAME');
		}else{
			$url='https://'.env('HTTP_HOST').'/'.env('SCRIPT_NAME');
		}
		showHeader();
		?>

        <h3>ローダーのインストールに失敗しました。</h3>

        システムのインストールは完了しましたが、ローダーのインストールに失敗しました。
        <br>


        どうしても問題が解消しない場合、<a href=<?php echo MAIN_SITE_URL; ?>/inquiries/add target="_blank">こちらからお問い合わせください。</a><br>
        なお、お問い合わせの際は、以下の枠内の情報をあわせてご連絡ください。

        <fieldset>
            <strong><?php echo sanitize($os_info); ?></strong><br>
            <strong><?php echo sanitize($php_version); ?></strong><br>
            <strong><?php echo sanitize($url); ?></strong><br>
            <pre><strong><?php echo sanitize(print_r($sys,true)); ?></strong></pre><br>
        </fieldset>

		<?php
		showFooter();
	}

	function showEnd(){
		if($_SESSION['dirname'] == '.'){
			$dir=dirname(__FILE__);
		}else{
			$dir=dirname(__FILE__).'/'.$_SESSION['dirname'];
		}
		$chmodresult=@chmod($dir, 0755);
		showHeader();
		?>

        <h3>インストール完了</h3>

        システムのインストールが完了しました。
        <br>

        <strong>安全な利用のため、以下の処理を必ず行ってください。</strong>
        <br>

        <ul>
            <li><?php echo dirname(__FILE__).'/'.INDEX_HTML; ?>は、サーバ上から削除してください。
            <li>このファイル (<?php echo dirname(__FILE__).'/'.INSTALLER_PHP; ?>) は、サーバー上から削除してください。
				<?php if(!$chmodresult): ?>
            <li>ディレクトリ (<?php echo dirname(__FILE__).'/'.$_SESSION['dirname']; ?>) のパーミッションを 755 にしてください。<br>
                777 のままですと、サーバーによっては、<?php echo SOFT_NAME; ?>にアクセスできません。
				<?php endif; ?>
        </ul>
        <br>

        上記の処理が終わったら、
        <a href="<?php echo sanitize($_SESSION['siteurl']); ?>" target="_blank">こちらのページより、さきほど設定した管理者ログインパスワードで<strong>必ず</strong>ログインしてください。</a>
        <br>

		<?php if($_SESSION['loadertype'] && !$this->checkLoader()): ?>

            <h3>ローダー</h3>
            ローダーが組み込まれていませんので、
            「<a href="<?php echo INSTALLER_PHP; ?>?act=senyo" target="_blank">php.iniへのローダーの組み込み方</a>」
            から作業をお願いします。
            <br>
            ローダーが組み込まれていないと<?php echo SOFT_NAME; ?>は動作しません。
            <br>


		<?php endif; ?>

		<?php
		showFooter();
	}
}
